//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit2.h"
//---------------------------------------------------------------------------
#pragma link "RVEdit"
#pragma link "RichView"
#pragma link "RVScroll"
#pragma resource "*.dfm"
TForm2 *Form2;
//---------------------------------------------------------------------------
__fastcall TForm2::TForm2(TComponent* Owner)
    : TForm(Owner)
{
}

#if __BORLANDC__>0x520
// Simple, but useful functions.
// Earlier version of C++Builder do not support TTable.CreateBlobStream...
bool SaveRVFToField(TCustomRichView*rv, TTable* tbl,
                        const AnsiString FieldName)
{
  TStream* Stream = tbl->CreateBlobStream(tbl->FieldByName(FieldName), bmWrite);
  bool r = rv->SaveRVFToStream(Stream, false);
  delete Stream;
  return r;
}

bool LoadRVFFromField(TCustomRichView* rv, TTable* tbl,
                          const AnsiString FieldName)
{
  TStream * Stream = tbl->CreateBlobStream(tbl->FieldByName(FieldName), bmRead);
  bool r = rv->LoadRVFFromStream(Stream);
  delete Stream;
  rv->Format();
  return r;
}

#else

bool SaveRVFToField(TCustomRichView*rv, TTable* tbl,
                        const AnsiString FieldName)
{
  TStream* Stream = new TMemoryStream;
  bool r = rv->SaveRVFToStream(Stream, false);
  Stream->Position = 0;
  ((TBlobField*)(tbl->FieldByName(FieldName)))->LoadFromStream(Stream);
  delete Stream;
  return r;
}

bool LoadRVFFromField(TCustomRichView* rv, TTable* tbl,
                          const AnsiString FieldName)
{
  TStream* Stream = new TMemoryStream;
  ((TBlobField*)(tbl->FieldByName(FieldName)))->SaveToStream(Stream);
  Stream->Position = 0;
  bool r = rv->LoadRVFFromStream(Stream);
  delete Stream;
  rv->Format();
  return r;
}

#endif
//---------------------------------------------------------------------------
void TForm2::SetField(const AnsiString AFieldName, TTable * ATable)
{
  FTable     = ATable;
  FFieldName = AFieldName;
  Load();
  Caption = FTable->FieldByName("Caption")->AsString;
}
//---------------------------------------------------------------------------
void TForm2::Load()
{
  LoadRVFFromField(RichViewEdit1, FTable, FFieldName);
  Modified = false;
}
//---------------------------------------------------------------------------
void TForm2::Save()
{
  FTable->Edit();
  SaveRVFToField(RichViewEdit1, FTable, FFieldName);
  FTable->Post();
  Modified = false;
}
//---------------------------------------------------------------------------
void __fastcall TForm2::RichViewEdit1Change(TObject *Sender)
{
  Modified = true;
}
//---------------------------------------------------------------------------
void __fastcall TForm2::SetModified(const bool Value)
{
  if (FModified!=Value)
  {
    FModified = Value;
    if (FModified)
      Panel1->Caption = "Modified";
    else
      Panel1->Caption = "";
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm2::btnPostClick(TObject *Sender)
{
  Save();    
}
//---------------------------------------------------------------------------
void __fastcall TForm2::btnCancelClick(TObject *Sender)
{
  Load();    
}
//---------------------------------------------------------------------------
void __fastcall TForm2::FormCloseQuery(TObject *Sender, bool &CanClose)
{
  if (Modified)
    switch (Application->MessageBox("Save changes?", "Text was modified",
         MB_YESNOCANCEL | MB_ICONQUESTION))
    {
      case IDYES:
        Save();
        CanClose = true;
        break;
      case IDNO:
        CanClose = true;
        break;
      case IDCANCEL:
        CanClose = false;
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm2::btnCloseClick(TObject *Sender)
{
  Close();    
}
//---------------------------------------------------------------------------
void __fastcall TForm2::RichViewEdit1CurTextStyleChanged(TObject *Sender)
{
  btnBold->Down = RichViewEdit1->CurTextStyleNo!=0;    
}
//---------------------------------------------------------------------------
void __fastcall TForm2::btnBoldClick(TObject *Sender)
{
  // switching 1-st and 0-th styles
  if (btnBold->Down)
    RichViewEdit1->ApplyTextStyle(1);
  else
    RichViewEdit1->ApplyTextStyle(0);
}
//---------------------------------------------------------------------------
